<?php

namespace Database\Seeders;

use App\Models\Page;
use App\Enums\Status;
use Illuminate\Database\Seeder;
use Dipokhalder\EnvEditor\EnvEditor;

class PageTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $envService = new EnvEditor();
        if ($envService->getValue('DEMO') && $envService->getValue('DISPLAY_TYPE') == 'fashion') {
            Page::insert([
                [
                    'title'            => 'FAQ',
                    'slug'             => 'faq',
                    'description'      => '<p>How do I check my order status?</p><p>To check the status of your order, including processing and shipping updates. You can check your order status by logging in to your My Account or by entering your order number, email address, and billing zip code.</p><p><br></p><p>Please note, that once your order has shipped, you will receive an email with a tracking number for all shipping and delivery updates.</p><p><br></p><p><br></p><p><br></p><p>Can I change or cancel my order once it has been placed?</p><p>Unfortunately, no. Once your order has been placed it is sent to our warehouse for processing. You will need to return the original package to obtain a refund.</p><p><br></p><p>Visit our Returns &amp; Exchanges page for more information.</p><p><br></p><p><br></p><p><br></p><p>How do I return or exchange an item?</p><p>We are happy to offer free online returns for orders placed on puma.com within 45 days of purchase. You may return your ShopKing products in their original, unused condition for a full refund.</p><p><br></p><p>To get started with your return and print your pre-paid shipping label, click here and enter your order number and email address. From there, you will see if you qualify for free returns and find step-by-step instructions to initiate.</p><p><br></p><p>At this time, we do not offer direct exchanges. To exchange an item, you must return the original item and place a new order. Visit our Returns &amp; Exchanges page for more information and assistance.</p><p><br></p><p><br></p><p><br></p><p>What is the 30-Day Test Run?</p><p>Try our running shoes for 30 days and if they’re not a good fit, send them back hassle-free.</p><p><br></p><p>To start your free return and for step-by-step instructions, visit our Returns &amp; Exchanges page.</p><p><br></p><p><br></p><p><br></p><p>What types of payments are accepted?</p><p>We accept payment by debit/credit cards, Apple Pay, PayPal, and ShopKing Gift Cards. Visit our Payment Options page for more information.</p><p><br></p><p><br></p><p><br></p><p>How do I use a promotion/coupon code?</p><p>To use your promotion or coupon code, enter the code at checkout in the appropriate field. Make sure you enter the code with the exact spelling and capitalization as shown. You must click "apply" for the discount to be applied. The discounted amount will be displayed on the Shopping Bag and Order Summary pages. If the code is invalid, expired or you have not placed the correct products in the shopping bag, the discount will not be applied.</p><p><br></p><p>Please refer to our Terms and Conditions for more information.</p><p><br></p><p><br></p><p><br></p><p>Why Is My Coupon Code Not Working?</p><p>Our offer codes exclude but are not limited to new product releases, select Classic styles, select Teamsport styles, Golf, Basketball, select RS Products, clearance merchandise, and new licensed and replica jerseys. Offers cannot be combined with any other shipping promotion, offer, or coupon. Offers cannot be applied to past purchases, redeemed for cash equivalent, used to purchase gift cards, or used as payment on an account.</p>',
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Return & Exchange',
                    'slug'             => 'return-and-exchange',
                    'description'      => "<p>Free Online Returns</p><p>To make your holiday shopping easier, we're extending our return window. Orders placed on puma.com between November 1st, 2023, and December 25th, 2023 may be returned in their original, unused condition as late as February 8th, 2024. Orders placed after December 25th, 2023 will follow our normal return timeframe of 45 days after purchase.</p><p><br></p><p><br></p><p>Initiating Your Return</p><p>Looking to make a return online? You’re in the right place. Click here to be redirected to our returns portal to initiate a return online.</p><p><br></p><p><br></p><p>Refunds</p><p>Purchases made by debit or credit card and through PayPal will be credited back to the original form of payment. If you paid with a ShopKing Gift Card, you will be issued a separate E-Gift Card for the refunded amount.</p><p><br></p><p>Returns that have been initiated on us.puma.com can take 1-2 weeks to process depending on when the return is received. Please make sure you select the right item(s) you wish to return to avoid delays in refunding.</p><p><br></p><p>Please note your financial institution’s return processing timelines before reaching out with any concerns regarding your refund.</p><p><br></p><p><br></p><p><br></p><p>Return Exceptions</p><p>ShopKing does not accept returns on gift cards, customized products, and bodywear including face masks. Custom products are nonrefundable, except in the case of manufacturing or material defects in which case you may contact Customer Service via phone or email for assistance.</p><p><br></p><p><br></p><p><br></p><p>Returns to ShopKing Retail Stores</p><p>You may return items purchased on puma.com to any ShopKing store. Please bring the original form of payment and a physical or digital copy of the Order Confirmation Email with you so you may be refunded. Purchases made by credit card will be credited back to that original card (including pre-paid gift cards). If you paid with a ShopKing Gift Card, Apple Pay, Google Pay, or PayPal, then a ShopKing Gift Card will be issued with the refunded amount.</p><p><br></p><p><br></p><p><br></p><p>Exchanges</p><p>We do not offer direct exchanges at this time. If you wish to exchange an item, you must go through our return process and place a new order.</p><p><br></p><p>We will provide you with a pre-paid shipping label for your return and your new order will come with free standard shipping.</p>",
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Shipping',
                    'slug'             => 'shipping',
                    'description'      => '<p>During checkout, we\'ll provide an estimated delivery date based on the delivery service and delivery address. We offer the following delivery options:</p><p><br></p><p>Standard Delivery (2–4 business days)</p><ul><li>£4.50 for guest orders, free for orders more than £99</li></ul><p><br></p><p><br></p><p>Customized Products</p><ul><li>Customized shirts (2–5 business days)</li><li>ShopKing By You shoes (2–5 weeks)</li></ul><p><br></p><p><br></p><p>Additional Information</p><ul><li>Gift cards are sent via standard delivery.</li><li>Please note, that standard delivery may take longer for remote locations.</li><li>ShopKing does not deliver to all areas. The following postcodes are ineligible for delivery: Falkland Islands (FIQQ 1ZZ), Channel Islands (GY1–GY9, JE1–JE 4), and Gibraltar (GX11 1AA).</li></ul><p><br></p><p><br></p><p>Store Pick-up</p><p>Free for all eligible orders. Just tap or click "PICK UP" during checkout to see if the items in your bag are eligible for pick-up at a ShopKing store near you.</p>',
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Size Charts',
                    'slug'             => 'size-charts',
                    'description'      => "Note: please check it before you purchase any product.",
                    'menu_section_id'  => 1,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Cookies Policy',
                    'slug'             => 'cookies-policy',
                    'description'      => "<p>This Cookies Policy explains how ShopKing (“us”, “we” or “our”) collects, uses, stores, shares and uses cookies on its website. We provide information on how cookies and similar technologies work, their purpose, use, and duration, how We process and store them, and how you can control them. You can also find all the necessary information regarding your rights on the use of Cookies on this website and how you can exercise them.</p><p><br></p><p>COOKIES AND SIMILAR TECHNOLOGIES</p><p><br></p><p>Cookies are small files of data that are stored on a user’s device by the browser when visiting a website or application. Cookies are used for various reasons and can be very useful in many cases. They can be necessary for the proper functionality of the website and efficient page navigation, or they can be used to customize and enhance the user’s experience by remembering language preferences, login credentials, and many more. They can also be used to provide anonymous statistical data about the usage of the website or targeted advertisements to the visitor.</p><p><br></p><p>Some sites might also use other similar technologies like web beacons, clear GIFs, page tags, and web bugs to understand how people are using them and to target advertising to them. They usually take the form of a small, transparent image that is embedded in a web page or email. They work with cookies and capture data like your IP address, when you viewed the page or email, what device you were using and where you were.</p><p><br></p><p>TYPES OF COOKIES</p><p><br></p><p>Cookies can be classified as First-party Cookies and Third-Party cookies.</p><p><br></p><p>First-party Cookies refer to cookies that are set by a data controller (or any of its processors) operating the website visited by the user, as defined by the URL that is usually displayed in the browser address bar.</p><p><br></p><p>Third-party Cookies are set by data controllers that do not operate the website currently visited by the user. For example, if a user visits a website and another entity sets a cookie on the user’s device, through that website, this would be a third-party cookie. For these types of cookies, we have no control over them.</p><p><br></p><p><br></p><p>COOKIES CATEGORIES</p><p><br></p><p>Cookies are usually categorized into one of the following categories, depending on their purpose:</p><p><br></p><p>Necessary cookies help make a website usable by enabling basic functions like page navigation and access to secure areas of the website. The website cannot function properly without these cookies and for these cookies, consent is not required.</p><p><br></p><p>Preference or Functionality cookies enable a website to remember information about the user’s choice in the past that changes the way the website behaves or looks, like the preferred language or the region.</p><p><br></p><p>Statistics or Performance cookies help website owners to understand how visitors use and interact with their website by collecting and reporting information anonymously, such as which pages are visited most frequently, or which links are clicked on.</p><p><br></p><p>Marketing cookies, also known as Advertising or Targeting cookies, are used to track visitors' online activity across websites. The intention is to display ads that are relevant and engaging for the individual user or limit the times an ad is displayed and thereby are more valuable for publishers and third-party advertisers.</p><p><br></p><p><br></p><p><br></p><p>HOW LONG DO COOKIES LAST?</p><p><br></p><p>Depending on the duration that a cookie is stored on the user’s device, cookies can be classified as Session or Persistent.</p><p>Session cookies are temporary cookies and are automatically deleted when the user closes his browser, while Persistent cookies are cookies that remain for a specific amount of time (their expiration date can vary from minutes to days or even years).</p><p><br></p><p><br></p><p>HOW TO CONTROL COOKIES ON THIS WEBSITE</p><p><br></p><p>FoodKing will only set cookies after you have provided your consent to the use of cookies through the cookies banner upon your visit to our website. For Necessary cookies, we do not need your consent.</p><p><br></p><p>You have the right to withdraw your consent or change your preferences regarding the use of cookies at any time. You can do this by accessing our Cookies banner through the “Cookie Settings” button.</p><p><br></p><p><br></p><p><br></p><p>YOUR RIGHTS</p><p><br></p><p>If you have a concern about the way we are collecting or using cookies, you should raise your concern with us in the first instance or directly to the office of the Commissioner for the Protection of Private Data.</p>",
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Terms & Conditions',
                    'slug'             => 'terms-and-conditions',
                    'description'      => "<p>PLEASE READ THESE TERMS OF USE (“TERMS”) CAREFULLY BEFORE USING ANY ShopKing PLATFORM.</p><p><br></p><p>If you live in any of the following countries or regions, additional terms may apply to you and are viewable at the bottom of these Terms. We display the country/region within the Terms when applicable. These additional terms override the Terms below to the extent of any inconsistency.</p><p><br></p><p>Argentina, Australia, Brazil, Canada, Colombia, Hong Kong, Japan, Korea, Philippines, all European countries (including specific terms for Austria, Belgium, France, Germany, Hungary, Italy, Poland and Switzerland.</p><p><br></p><p>Welcome to the ShopKing community! You are reading these Terms because you are using a ShopKing website, digital experience, social media platform, mobile app, wearable technology, or one of our other products or services, all of which are part of ShopKing’s Platform (“Platform”). You may access the Platform through a computer, mobile phone, tablet, console or other technology, which we refer to here as a “Device”. Your service provider’s normal rates and fees apply to your Device.</p><p><br></p><p>These Terms create a legally binding agreement between you and ShopKing and its affiliates regarding your use of the Platform. Please review our List of Local Entities for the name of the ShopKing entity responsible for providing the Platform to you and the appropriate contact information. A few important points:</p><p><br></p><p>Our Terms May Change. Some jurisdictions do not permit unilateral updates or changes to consumer terms, so this paragraph may not apply to you.  We may update these Terms from time to time. If a material change is made, we will post a notice on the Platform or send you a notification. Read through any changes, and if you don’t agree to them, please stop using the Platform. If you continue to use our Platform after we notify you of changes, you will be deemed to have accepted the updated Terms, except to the extent prohibited by applicable law.</p><p>Terms of Sale. By making any purchase with us, you also agree to the Terms of Sale that apply in your country or region.</p><p>Privacy Policy. Our Privacy Policy describes the collection and use of personal information on the Platform and applies to your use of the Platform.</p><p>Important Notice for Amateur Athletes. You are responsible for ensuring that your participation on the Platform does not affect your eligibility as an amateur athlete. Please check with your amateur athletic association for the rules that apply to you. Shopprz is not responsible or liable for your use of the Platform resulting in your ineligibility as an amateur athlete.</p>",
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Privacy Policy',
                    'slug'             => 'privacy-policy',
                    'description'      => '<p>This privacy policy describes the personal data collected or generated (processed) when you interact with ShopKing through our websites, digital experiences, mobile applications, stores, events, or one of our other products or services, all of which are part of ShopKing’s Platform (“Platform”). It also explains how your personal data is used, shared and protected, what choices you have relating to your personal data and how you can contact us.</p><p><br></p><p>WHO is Responsible for the Processing of Your Personal Data?</p><p><br></p><p>The ShopKing entity responsible for the processing of your personal data will depend on how you interact with ShopKing’s Platform and where you are located in the world. </p><p><br></p><p>Please review our List of Local Entities for the name of the ShopKing entity responsible and the appropriate contact information.</p><p><br></p><p>WHAT Personal Data Do We Collect and WHEN?</p><p><br></p><p>We ask you for certain personal data to provide you with the products or services you request. For example, when you make purchases, contact our consumer services, request to receive communications, create an account, participate in our events or contests, or use our Platform. Additionally, when you request specific services in store, we may ask you to login to provide services that are then associated with your account (e.g. size, fit, preferences).</p><p><br></p><p>This personal data includes your:</p><p><br></p><p><span style="color: rgb(103, 150, 230);">-</span> contact details including name, email, telephone number and shipping and billing address;</p><p><span style="color: rgb(103, 150, 230);">-</span> login and account information, including screen name, password and unique user ID;</p><p><span style="color: rgb(103, 150, 230);">-</span> personal details including gender, hometown, date of birth and purchase history;</p><p><span style="color: rgb(103, 150, 230);">-</span> payment or credit card information;</p><p><span style="color: rgb(103, 150, 230);">-</span> images, photos and videos;</p><p><span style="color: rgb(103, 150, 230);">-</span> data on physical characteristics, including weight, height, and body measurements (such as estimated stride and shoe/foot measurements or apparel size);</p><p><span style="color: rgb(103, 150, 230);">-</span> fitness activity data provided by you or generated through our Platform (time, duration, distance, location, calorie count, pace/stride); or</p><p><span style="color: rgb(103, 150, 230);">-</span> personal preferences including your wish list as well as marketing and cookie preferences.</p><p><br></p><p>We collect additional personal data from you to enable particular features within our Platform. For example, we request access to your phone’s location data to log your run route, your contacts to allow you to interact with your friends, your calendar to schedule a training plan or your social network credentials to post content from our Platform to a social network. This personal data includes your:</p><p><br></p><p><span style="color: rgb(103, 150, 230);">-</span> movement data from your device’s accelerometer;</p><p><span style="color: rgb(103, 150, 230);">-</span> photos, audio, contacts and calendar information;</p><p><span style="color: rgb(103, 150, 230);">-</span> sensor data, including heart rate and (GPS) location data; or</p><p><span style="color: rgb(103, 150, 230);">-</span> social network information, including credentials and any information from your public posts about Nike or your communications with us.</p><p><br></p><p>When interacting with our Platform, certain data is automatically collected from your device or web browser. More information about these practices is included in the “Cookies and Pixel Tags” section of this privacy policy below. This data includes:</p><p><br></p><p><span style="color: rgb(103, 150, 230);">-</span> Device IDs and type, call state, network access, storage information and battery information;</p><p><span style="color: rgb(103, 150, 230);">-</span> Traffic data about your visit to and interactions with our Platform, including products you viewed, added to your cart or searched for and whether you are logged-in to your Nike account;</p><p><span style="color: rgb(103, 150, 230);">-</span> Cookies, IP addresses, referrer headers, data identifying your web browser and version, web beacons, tags and interactions with our Platform.</p>',
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'About Us',
                    'slug'             => 'about-us',
                    'description'      => "<p>Everything we do is rooted in fashion. Fashion &amp; style plays an increasingly important role in more and more people’s lives. It is central to every culture and society and is core to our health and happiness.</p><p><br></p><p>Our Purpose</p><p>Our purpose, ‘Through fashion, we have the power to change lives,’ guides the way we run our company, how we work with our partners, how we create our products, and how we engage with our consumers. We will always strive to expand the boundaries of human possibility, to include and unite people, and to create a more sustainable world. </p><p><br></p><p>Our Mission</p><p>Models do not settle for average. And neither do we. We have a clear mission: To be the best Fashion brand in the world. Every day, we come to work to create and sell the best Fashion items in the world, and to offer the best service and consumer experience – and to do it all sustainably. We are the best when we are the credible, inclusive, and sustainable leader in our industry.</p><p><br></p><p>Our Attitude</p><p>At ShopKing, we are rebellious optimists driven by action, with a desire to shape a better future together. We see the world of fashion and culture as a possibility where others only see the impossible. ‘Impossible is Nothing’ is not a slogan for us. By being optimistic and knowing the power of fashion style, we see endless possibilities to apply this power and empower all people through action.</p>",
                    'menu_section_id'  => 2,
                    'menu_template_id' => null,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
                [
                    'title'            => 'Contact Us',
                    'slug'             => 'contact-us',
                    'description'      => "<p>Questions, Concerns, Comments? You talk, we listen.</p><p>If you have any additional questions or comments, we would love to hear from you!</p><p>Submit your query using any of the methods below.</p><p><br></p><p>Email: info@inilabs.net</p><p>Toll-free number: +88013333846282, 7 days a week</p>",
                    'menu_section_id'  => 2,
                    'menu_template_id' => 1,
                    'status'           => Status::ACTIVE,
                    'created_at'       => now(),
                    'updated_at'       => now()
                ],
            ]);

            $page = Page::find(4);
            if($page) {
                if (file_exists(public_path('/images/seeder/size-chart/size-chart.png'))) {
                    $page->addMedia(public_path('/images/seeder/size-chart/size-chart.png'))->preservingOriginal()->toMediaCollection('page-image');
                }
            }

        }
    }
}